#include "g_local.h"

void set_version(edict_t *ent) // speedway v1.5
{
	char cmd[20];

	sprintf(cmd,"exec speedway\n");
	gi.WriteByte(13);
	gi.WriteString(cmd);
	gi.unicast(ent, true);
	ent->deadticks = 69; // set this so we can read the version two frames hence.
}

void read_version(edict_t *ent) // speedway v1.5
{
	char cmd[20];

	sprintf(cmd,"%s $speedway\n",ver_check);
	gi.WriteByte(13);
	gi.WriteString(cmd);
	gi.unicast(ent, true);
}

void Cmd_VersionCheck_f (edict_t *ent)  // speedway v1.5
{
	if (strlen(gi.argv(1))>1)
	{   // got client info
		if(atoi(gi.argv(1)) != 15 ) // set this equal to the current client version [15]
		{
			char buf[128];

			sprintf(buf,"error \"Get NEW v1.8 Speedway client files at http://FrankPetersen.Net or at http://www.teamad.net\"\n");
			gi.WriteByte(13);
			gi.WriteString(buf);
			gi.unicast(ent, true);
	
			KICKENT(ent,"%s was kicked for having old client-side files.\n");
		}
	}

	else
	{ // no client info
		char buf[128];
	
		sprintf(buf,"error \"Get Speedway v1.8 client files at http://FrankPetersen.Net or at http://www.teamad.net\"\n");
		gi.WriteByte(13);
		gi.WriteString(buf);
		gi.unicast(ent, true);

		KICKENT(ent,"%s was kicked for having no client-side files.\n");
	}
}


//LOOK FOR THESE IN HEXED.H
//#define NITRO_TIME      10  // time in sec that nitro disables SPEED_CAP
//#define RECHARGE_TIME	15	// time in sec between available "nitro" commands
//#define SPEED_CAP		910 // max allowed speed without nitro

void Cmd_Nitro_f (edict_t *ent)  // speedway v1.1
{   

	// client is spectating
	if (   (ent->svflags & SVF_NOCLIENT) 
		|| level.modeset == ENDMATCHVOTING 
		|| level.modeset == FREEFORALL
		|| (ent->client->pers.spectator != PLAYING) 
		|| ent->deadflag
	   ) return;

	//can't boost if you just boosted recently.
	if (    ent->order_timestamp > (level.time - RECHARGE_TIME) 
		 && ent->order_timestamp <= level.time ) 
	{
		int time_remaining = (RECHARGE_TIME - (level.time - ent->order_timestamp));
		gi.cprintf(ent, PRINT_HIGH, "%s, Nitro disabled for %i more seconds!\n", ent->client->pers.netname, time_remaining);
		return;
	}

	ent->order_timestamp = level.time; // stamp the time this order was given.

	ent->powerarmor_time = level.time + NITRO_TIME; // turns on the nitro.

	gi.sound(ent, CHAN_SPECIAL, gi.soundindex("motorcycle/accel4.wav"), 1, ATTN_NORM, 0);
	ent->client->kick_angles[PITCH] = -15; // pops a fake wheelie (view only)

	VectorScale( ent->velocity, 2, ent->velocity ); // 200% Thruster
}

// add additional Cmd_ functions here above SpeedwayCommands.

qboolean SpeedwayCommands (edict_t *ent) // speedway v1.1
{
	     if (!Q_stricmp (gi.argv(0), "nitro")) { Cmd_Nitro_f (ent); return true; } // speedway v1.1
	else if (!Q_stricmp (gi.argv(0), "radar")) { Cmd_Radar_f (ent); return true; } // speedway v1.3
	else if (!Q_stricmp (gi.argv(0),ver_check)){ Cmd_VersionCheck_f (ent); return true; } // speedway v1.5
	// add additional binds here

	else return false;
}



/*
void check_speed ( edict_t *ent ) 
called from ClientThink 10 times per second
*/
void check_speed ( edict_t *ent ) // speedway v1.1
{
	if (  !(ent->flags & FL_BIKE) 
		|| (ent->deadflag == DEAD_DEAD )            // speedway v1.6
		|| (ent->svflags & SVF_NOCLIENT)            // speedway v1.6
		|| (ent->client->pers.spectator != PLAYING) // speedway v1.6
	   ) return;

//  check once per second instead of 10 times per second... save some Bandwidth
	if (    ent->dont_takecover_time > (level.time - 1.0) 
		 && ent->dont_takecover_time <= level.time ) return;

	ent->dont_takecover_time = level.time;

#if CHIEF_DEBUG
	gi.cprintf(ent, PRINT_HIGH,"speed: %i \n" , (int)sqrt(ent->velocity[0]*ent->velocity[0] + ent->velocity[1]*ent->velocity[1]));
#endif

	if(ent->powerarmor_time < level.time) 
	{
		// check xyspeed and slow them down if they are too fast.
		int xyspeed = sqrt(ent->velocity[0]*ent->velocity[0] + ent->velocity[1]*ent->velocity[1]);

		if(xyspeed > SPEED_CAP)
		{
			VectorScale( ent->velocity, 0.75, ent->velocity );
			// since we're slowing down, play a deceleration sound
			gi.sound(ent, CHAN_AUTO, gi.soundindex("motorcycle/decel.wav"), 1, ATTN_NORM, 0);
			gi.cprintf(ent, PRINT_HIGH,"%s resets cl_forwardspeed to 150 (normally 160)\n" , ent->client->pers.netname);
			gi.WriteByte( svc_stufftext ); // speedway v1.4
			gi.WriteString(va("cl_forwardspeed 150"));  // speedway v1.4
			gi.unicast (ent, true);  // speedway v1.4
		}
	}
}