/*
    Gloom Server Browser
    Copyright (C) 2001-2003  Richard Stanway (www.r1ch.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winuser.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <stdio.h>
#include <shlwapi.h>
#include <commctrl.h>
#include <winsock.h>
#include <Mmsystem.h>
#include <string.h>
#include <direct.h>
#include "resource.h"
#include <Wininet.h>

#define MAX_LOADSTRING 100

typedef struct _PLAYERINFO {
	char playername[16];
	int ping;
	int score;
} PLAYERINFO;

typedef struct _SERVERINFO {
	unsigned int ip;
	//char host[256];
	unsigned short port;
	char szHostName[256];
	char szMapName[256];
	int curClients;
	int maxClients;
	DWORD startPing;
	int	ping;
	PLAYERINFO players[64];
	int temporary;
} SERVERINFO;

SERVERINFO servers[64];

DWORD altmethod = 0;

char q2Path[MAX_PATH];
char q2Exe[MAX_PATH];

char szAppName[] = "CodeRED Server Browser";

#define UM_INIT2 (WM_USER+1)

int globalServers = 0;
int globalPlayers = 0;

SOCKET sckUpdate;

HWND hWndRefresh;
HWND hWndStatus;
//HWND hWndInfoList;
HWND hWndPlayerList;
HWND hWndList;
HWND hwndMain;
HWND hDlgUpdate;

int pending = 0;

// Global Variables:
HINSTANCE hThisInstance;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name

HANDLE PingHandle = NULL;
DWORD PingThreadID = 0;

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK Proxy(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

int numServers = 0;

static int lastSortOrder = -1;
static int lastSortOrder2 = -1;

char resolveinfo[MAXGETHOSTSTRUCT];

//#define nParts 4
void RequestHandler (void);

void DoServerRefresh (void)
{
	//clear lists
	SendMessage (hWndList, LVM_DELETEALLITEMS, 0, 0);
	SendMessage (hWndPlayerList, LVM_DELETEALLITEMS, 0, 0);
	//SendMessage (hWndInfoList, LVM_DELETEALLITEMS, 0, 0);

	lastSortOrder = -1;
	lastSortOrder2 = -1;

	//nuke array
	/*for (i = 0; i < numServers; i++) {
		memset (&servers[i].players, 0, sizeof(servers[i]).players);
	}*/

	globalPlayers = globalServers = pending = 0;

	SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 1, (LPARAM) "0 Players");
	SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 2, (LPARAM) "0 Servers");

	if (!numServers) {
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "No servers to query! Hit 'Update'");
		return;
	}

	SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "Refreshing...");

	//restart thread
	PingHandle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) RequestHandler, 0, 0, &PingThreadID);
	if (PingHandle) {
		CloseHandle(PingHandle);
	}
}

void SckError (char *usermsg)
{
	char *final;
	char message[1024];

	if (usermsg) {
		final = usermsg;
	} else {
		DWORD code;

		code = GetLastError();

		sprintf (message, "ERROR: WinInet Error (%d)", code);
		final = message;
	}

	if (strlen(final) > 50) {
		MessageBox (hDlgUpdate, final, "WinInet Error", MB_OK + MB_ICONEXCLAMATION);
	}

	SetDlgItemText (hDlgUpdate, IDC_STATUSMSG, final);
	SendDlgItemMessage (hDlgUpdate, IDC_PROGRESS1, PBM_SETPOS, (WPARAM)5, 0);
	SetDlgItemText (hDlgUpdate, IDC_CANCEL, "Close");
}

char *HPIFindTADir (char *Path) {
	char *TAdir;
	WIN32_FIND_DATA FileData; 
	HANDLE hSearch; 
	char myPath[MAX_PATH];
	char szNewPath[MAX_PATH]; 
	 
	BOOL fFinished = FALSE; 

	strcpy (myPath, Path);
	strcat (myPath, "*");
	hSearch = FindFirstFile(myPath, &FileData); 

	if (hSearch == INVALID_HANDLE_VALUE) { 
		return NULL;
	} 
	 
	while (!fFinished) 
	{ 
		lstrcpy(szNewPath, Path); 
		lstrcat(szNewPath, FileData.cFileName); 

		if (FileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY && strcmp (FileData.cFileName, ".") && strcmp (FileData.cFileName, "..")) {
			lstrcat (szNewPath, "\\");
			TAdir = HPIFindTADir (szNewPath);
			if (TAdir) {
				FindClose(hSearch);
				return TAdir;
			}
		} else if (!_stricmp (FileData.cFileName, q2Exe)) {
			char buff[512];
			int ans;
			sprintf (buff, "GSB detected a '%s' in:\n    %s\nIs this the one you wish to use?", q2Exe, Path);
			ans = MessageBox (hwndMain, buff, "CodeRED Location", MB_YESNO + MB_ICONQUESTION);
			if (ans == IDYES) {
				FindClose(hSearch);
				return Path;
			}
		}
	 
		if (!FindNextFile(hSearch, &FileData))
			fFinished = TRUE; 
	} 
	 
	// Close the search handle. 
	FindClose(hSearch);
	return NULL;
}

void SaveStuff(void)
{
//	int i;
//	FILE *cache;
	DWORD result;
	HKEY hk;
	
	RegCreateKeyEx  (HKEY_LOCAL_MACHINE, "SOFTWARE\\COR\\CodeRED Server Browser", 0, NULL, 0, KEY_WRITE, NULL, &hk, &result);
	RegOpenKeyEx (HKEY_LOCAL_MACHINE, "SOFTWARE\\COR\\CodeRED Server Browser", 0, KEY_WRITE, &hk);
	RegSetValueEx (hk, "Q2Dir", 0, REG_SZ, (const BYTE *)q2Path, strlen(q2Path)+1);
	RegSetValueEx (hk, "q2Exe", 0, REG_SZ, (const BYTE *)q2Exe, strlen(q2Exe)+1);

	RegSetValueEx (hk, "Alt. Startup Method", 0, REG_DWORD, (const BYTE *)&altmethod, sizeof(DWORD));

	/*cache = fopen("./server-1.0.9.cache", "wb");
	if (cache) {
		for (i = 0; i < numServers; i++) {
			fwrite (&servers[i], sizeof(SERVERINFO), 1, cache);
		}
		fclose (cache);
	}*/

	WSACleanup();
}

void RunQ2 (NMITEMACTIVATE *info)
{
	HCURSOR hcSave;
	LVITEM pitem;
//	STARTUPINFO s; 
	BOOL foundIt = FALSE;
	//HKEY hk;
	char Server[128];
	int drive, index;
	int size = MAX_PATH;

	if (info->iItem == -1)
		return;

	//busy = TRUE;

	hcSave = SetCursor(LoadCursor(NULL, IDC_WAIT));
	
	memset (&pitem, 0, sizeof(pitem));

	pitem.iItem = info->iItem;
	pitem.iSubItem = 0;
	pitem.mask = LVIF_PARAM;

	//index = SendMessage (hWndList, LVM_GETSELECTIONMARK, 0, 0);
	SendMessage (hWndList, LVM_GETITEM, 0, (LPARAM)(LPLVITEM)&pitem);
	
	index = pitem.lParam;

	if (!q2Path[0]) {
		for ( drive = 3; drive <= 26; drive++ ) {
			if( !_chdrive( drive ) ) {
				char *temp;
				char dirtogo[4];
				sprintf (dirtogo, "%c:\\", drive + 'A' - 1);
				sprintf (Server, "Trying to find %s on %s...", q2Exe, dirtogo);
				SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) Server);
				temp = HPIFindTADir (dirtogo);
				if (temp)
					strcpy (q2Path, temp);
				if (q2Path[0])
					break;
			}
		}
	}

	{
		struct in_addr tmp;
		tmp.S_un.S_addr = servers[index].ip;
		sprintf (Server, "%s:%d", inet_ntoa(tmp), servers[index].port); 
	}

	//busy = FALSE;
	//SetClassLong(hwndMain, GCL_HCURSOR, (LONG) LoadCursor (hThisInstance, IDC_ARROW));   

	SetCursor(hcSave);

	if (!q2Path[0]) {
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM)"Couldn't find a CodeRED executable!");
		MessageBox (hwndMain, "Unable to find your CodeRED executable!\n\nYou can't join a server until you have specified where CodeRED is on your system.\n\nTry setting the executable name manually in the config if you have a different executable name.", "Can't find CodeRED", MB_OK + MB_ICONEXCLAMATION);
	} else {
		STARTUPINFO s; 
		HANDLE in;
		char q2buff[MAX_PATH];
		PROCESS_INFORMATION p;
		char cmdLine[512];
		char myQ2Path[MAX_PATH];

		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "Starting CodeRED...");

		strcpy (myQ2Path, q2Path);
		memset (&s, 0, sizeof(s));
		s.cb = sizeof(s);
		myQ2Path[strlen(myQ2Path)-1] = '\0';

		sprintf (q2buff, "%s\\%s", myQ2Path, q2Exe);
		in = CreateFile (q2buff, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
		if (in == INVALID_HANDLE_VALUE) {
			char buff[512];
			SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "Couldn't find CodeRED executable! Check your config.");
			sprintf (buff, "Error: Couldn't find a CodeRED executable:\n    %s: File Not Found", q2buff);
			MessageBox (hwndMain, buff, "Couldn't find CodeRED", MB_OK + MB_ICONEXCLAMATION);
			return;
		}

		if (altmethod == 1) {
			sprintf (cmdLine, "+set game arena +connect %s", Server);
			CreateProcess (q2buff, cmdLine, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, myQ2Path, &s, &p);
		} else if (altmethod == 0) {
			sprintf (cmdLine, "+set game arena +connect %s", Server);
			CreateProcess (q2buff, cmdLine, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, myQ2Path, &s, &p);
		} else {
			sprintf (cmdLine, "\"%s\\%s\" +set game arena +connect %s", myQ2Path, q2Exe, Server);
			CreateProcess (NULL, cmdLine, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, myQ2Path, &s, &p);
		}
		SaveStuff();
		PostQuitMessage(0);
	}
}

BOOL InitListViewImageLists(HWND hWndListView) 
{ 
    HICON hiconItem;     // icon for list-view items 
   // HIMAGELIST hLarge;   // image list for icon view 
    HIMAGELIST hSmall;   // image list for other views 
	HIMAGELIST hSmall2;   // image list for other views 
 
    // Create the full-sized icon image lists. 
    hSmall = ImageList_Create(16, 
        14, ILC_MASK, 5, 0); 
 
    hSmall2 = ImageList_Create(16, 
        14, ILC_MASK, 1, 0); 

    // Add an icon to each image list.  
    hiconItem = LoadIcon(hThisInstance, MAKEINTRESOURCE(IDI_ICON2)); 
    ImageList_AddIcon(hSmall, hiconItem); 
    DestroyIcon(hiconItem); 
    hiconItem = LoadIcon(hThisInstance, MAKEINTRESOURCE(IDI_ICON4)); 
    ImageList_AddIcon(hSmall, hiconItem); 
    DestroyIcon(hiconItem); 
    hiconItem = LoadIcon(hThisInstance, MAKEINTRESOURCE(IDI_ICON6)); 
    ImageList_AddIcon(hSmall, hiconItem); 
    DestroyIcon(hiconItem); 
    hiconItem = LoadIcon(hThisInstance, MAKEINTRESOURCE(IDI_ICON5)); 
    ImageList_AddIcon(hSmall, hiconItem); 
    DestroyIcon(hiconItem);

    hiconItem = LoadIcon(hThisInstance, MAKEINTRESOURCE(IDI_ICON1)); 
    ImageList_AddIcon(hSmall2, hiconItem); 
    DestroyIcon(hiconItem); 
    /*********************************************************
    Usually you have multiple icons; therefore, the previous
    four lines of code can be inside a loop. The following code 
    shows such a loop. The icons are defined in the application's
    header file as resources, which are numbered consecutively
    starting with IDS_FIRSTICON. The number of icons is
    defined in the header file as C_ICONS.
	
    for(index = 0; index < C_ICONS; index++)
    {
    hIconItem = LoadIcon (hInst, MAKEINTRESOURCE (IDS_FIRSTICON +
	            index));
    ImageList_AddIcon(hSmall, hIconItem);
    ImageList_AddIcon(hLarge, hIconItem);
    Destroy(hIconItem);
    }
    *********************************************************/
 
    // Assign the image lists to the list-view control. 
    //ListView_SetImageList(hwndLV, hLarge, LVSIL_NORMAL); 
    ListView_SetImageList(hWndListView, hSmall, LVSIL_SMALL);
	ListView_SetImageList(hWndPlayerList, hSmall2, LVSIL_SMALL);
    return TRUE; 
} 

int CALLBACK CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LPARAM inverseTemp;

	if (lParamSort == lastSortOrder2) {
		inverseTemp = lParam1;
		lParam1 = lParam2;
		lParam2 = inverseTemp;
	}

	switch ((int)lParamSort) {
		case 0:
			return strcmp (servers[(int)lParam1].szHostName, servers[(int)lParam2].szHostName);
		case 1:
			if ((long)servers[(int)lParam1].ip < (long)servers[(int)lParam2].ip)
				return -1;
			if ((long)servers[(int)lParam1].ip > (long)servers[(int)lParam2].ip)
				return 1;
			else
				return 0;
			//return strcmp (servers[(int)lParam1].ip, servers[(int)lParam2].host);
		case 2:
			return strcmp (servers[(int)lParam1].szMapName, servers[(int)lParam2].szMapName);
		case 3:
			if (servers[(int)lParam1].curClients < servers[(int)lParam2].curClients)
				return 1;
			else if (servers[(int)lParam1].curClients > servers[(int)lParam2].curClients)
				return -1;
			else
				return 0;
		case 4:
			if (servers[(int)lParam1].ping < servers[(int)lParam2].ping)
				return -1;
			else if (servers[(int)lParam1].ping > servers[(int)lParam2].ping)
				return 1;
			else
				return 0;
		default:
			return 0;
	}
}

int CALLBACK CompareFunc2(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	LPARAM inverseTemp;
	LVITEM pitem;
	int index;

	index = SendMessage (hWndList, LVM_GETSELECTIONMARK, 0, 0);
	memset (&pitem, 0, sizeof(pitem));
	pitem.iItem = index;
	pitem.iSubItem = 0;
	pitem.mask = LVIF_PARAM;

	SendMessage (hWndList, LVM_GETITEM, 0, (LPARAM)(LPLVITEM)&pitem);
	index = pitem.lParam;

	if (lParamSort == lastSortOrder) {
		inverseTemp = lParam1;
		lParam1 = lParam2;
		lParam2 = inverseTemp;
	}

	switch ((int)lParamSort) {
		case 0:
			return strcmp (servers[index].players[(int)lParam1].playername, servers[index].players[(int)lParam2].playername);
		case 1:
			if (servers[index].players[(int)lParam1].score < servers[index].players[(int)lParam2].score)
				return 1;
			else if (servers[index].players[(int)lParam1].score > servers[index].players[(int)lParam2].score)
				return -1;
			else
				return 0;
		case 2:
			if (servers[index].players[(int)lParam1].ping < servers[index].players[(int)lParam2].ping)
				return -1;
			else if (servers[index].players[(int)lParam1].ping > servers[index].players[(int)lParam2].ping)
				return 1;
			else
				return 0;
		default:
			return 0;
	}
}

HWND LV_CreateListView (HWND hWndParent, HINSTANCE hInst, int NumServers,
    SERVERINFO *pServer)
{
	HWND temp;
	HICON icon;
 HWND hWndList;      // handle to the list view window
 RECT rcl;           // rectangle for setting the size of the window
// HICON hIcon;        // handle to an icon
 int index;          // index used in FOR loops
 LV_COLUMN lvC;      // list view column structure
// char szText[64];    // place to store some text
 int iWidth;         // column width
 int width[5];
// COLORREF  color;
 char *columnTitle[5];



 width[0] = 35;
 width[1] = 20;
 width[2] = 20;
 width[3] = 13;
 width[4] = 12;
columnTitle[0] = "Host Name";
columnTitle[1] = "Address";
columnTitle[2] = "Map";
columnTitle[3] = "Players";
columnTitle[4] = "Ping";
 // Get the size and position of the parent window.
 GetClientRect(hWndParent, &rcl);

 // Create the list view window, make it 3/4 the size of the
 // parent window, and take the status bar and toolbar into account.
 iWidth = (rcl.right - rcl.left);
 hWndList = CreateWindowEx( 0L,
     WC_LISTVIEW,
     "",                                 // no default text
     WS_VISIBLE | WS_CHILD | LVS_REPORT | WS_BORDER | LVS_SHAREIMAGELISTS | LVS_SINGLESEL,  // styles
     0, 0,       // x, y
     iWidth, ((rcl.bottom - rcl.top) / 2),  // cx, cy
     hWndParent,                         // parent
     NULL,                // identifier
     hInst,                              // instance
     NULL );

 hWndPlayerList = CreateWindowEx( 0L,
     WC_LISTVIEW,
     "",                                 // no default text
     WS_VISIBLE | WS_CHILD | LVS_REPORT | WS_BORDER | LVS_SHAREIMAGELISTS | LVS_SINGLESEL,  // styles
     0, ((rcl.bottom - rcl.top) / 2) + 2,       // x, y
     iWidth - 90, ((rcl.bottom - rcl.top) / 2) - 22,  // cx, cy
     hWndParent,                         // parent
     NULL,                // identifier
     hInst,                              // instance
     NULL );


// SetWindowLong(hWndInfoList, GWL_ID, LIST_INFO);
 SetWindowLong(hWndPlayerList, GWL_ID, LIST_PLAYERS);
 SetWindowLong(hWndList, GWL_ID, LIST_SERVERS);

 temp = CreateWindow ("Button", "Exit", WS_CHILD | WS_VISIBLE, iWidth - 84,
			  (rcl.bottom - rcl.top) - 22 - 32 , 78, 24, hWndParent, (HMENU)NULL,
			  hThisInstance, 0);

SetWindowLong(temp, GWL_ID, BUTTON_EXIT);

 hWndRefresh = CreateWindow ("Button", "Refresh", WS_CHILD | WS_VISIBLE | WS_DISABLED, iWidth - 84,
			  (rcl.bottom - rcl.top) - 22 - 32 - 8 - 32 , 78, 24, hWndParent, (HMENU)NULL,
			  hThisInstance, 0);

SetWindowLong(hWndRefresh, GWL_ID, BUTTON_REFRESH);

 temp = CreateWindow ("Button", "Config", WS_CHILD | WS_VISIBLE, iWidth - 84,
			  (rcl.bottom - rcl.top) - 22 - 32 - 8 - 32 - 8 - 32, 78, 24, hWndParent, (HMENU)NULL,
			  hThisInstance, 0);

SetWindowLong(temp, GWL_ID, BUTTON_PROXY);

 temp = CreateWindow ("Button", "Update", WS_CHILD | WS_VISIBLE, iWidth - 84,
			  (rcl.bottom - rcl.top) - 22 - 32 - 8 - 32 - 8 - 32 -8 - 32, 78, 24, hWndParent, (HMENU)NULL,
			  hThisInstance, 0);

SetWindowLong(temp, GWL_ID, BUTTON_ABOUT);


	SendMessage (hWndList, LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM) LVS_EX_SUBITEMIMAGES | LVS_EX_FULLROWSELECT);
	SendMessage (hWndPlayerList, LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM) LVS_EX_SUBITEMIMAGES | LVS_EX_FULLROWSELECT);


 if (hWndList == NULL )
  return NULL;

 // Initialize the LV_COLUMN structure.
 // The mask specifies that the .fmt, .ex, width, and .subitem members 
 // of the structure are valid.
 lvC.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
 lvC.fmt = LVCFMT_LEFT;  // left-align the column

 // Add the columns.
 for (index = 0; index < 5; index++)
 {
	lvC.cx = (int)(iWidth * (width[index] / 103.0f));
  lvC.iSubItem = index;
  lvC.pszText = columnTitle[index];
  if (ListView_InsertColumn(hWndList, index, &lvC) == -1)
     return NULL;
 }

columnTitle[0] = "Name";
columnTitle[1] = "Score";
columnTitle[2] = "Ping";
 width[0] = 50;
 width[1] = 25;
 width[2] = 25;
 for (index = 0; index < 3; index++)  {
	lvC.cx = (int)(iWidth / 1.4 * (width[index] / 107.0f));
  lvC.iSubItem = index;
  lvC.pszText = columnTitle[index];
  if (ListView_InsertColumn(hWndPlayerList, index, &lvC) == -1)
     return NULL;
 }

 hWndStatus = CreateWindow (STATUSCLASSNAME, "", WS_CHILD | WS_VISIBLE, 0, 0, iWidth+2, 0,  hwndMain, (HMENU)NULL, hInst, 0);

	width[0] = 42;
	width[1] = 15;
	width[2] = 15;

 for (index =0; index < 3; index++) {
	 if (index)
		width[index] = (int)(iWidth * (width[index] / 70.0f)) + width[index-1];
	 else
		 width[index] = (int)(iWidth * (width[index] / 70.0f));
 }
	
    // Tell the status bar to create the window parts. 
    SendMessage(hWndStatus, SB_SETPARTS, (WPARAM) 3, 
        (LPARAM) width); 
 
	icon = (HICON)LoadImage(hThisInstance, MAKEINTRESOURCE(IDI_ICON1), IMAGE_ICON, 16, 14, LR_DEFAULTCOLOR);
    SendMessage(hWndStatus, SB_SETICON, (WPARAM)(INT) 1, 
        (LPARAM)icon);

	icon = (HICON)LoadImage(hThisInstance, MAKEINTRESOURCE(IDI_ICON2), IMAGE_ICON, 16, 14, LR_DEFAULTCOLOR);
    SendMessage(hWndStatus, SB_SETICON, (WPARAM)(INT) 2, 
        (LPARAM)icon);

	icon = (HICON)LoadImage(hThisInstance, MAKEINTRESOURCE(IDI_ICON3), IMAGE_ICON, 14, 14, LR_DEFAULTCOLOR);
    SendMessage(hWndStatus, SB_SETICON, (WPARAM)(INT) 0, 
        (LPARAM)icon);

	SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "Updating Server List...");
	SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 1, (LPARAM) "0 Players");
	SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 2, (LPARAM) "0 Servers");

	InitListViewImageLists (hWndList);

return (hWndList);
}

char *GetLine (char **contents, int *len)
{
	int num;
	int i;
	char line[2048];
	char *ret;

	num = 0;
	line[0] = '\0';

	if (*len <= 0)
		return NULL;

	for (i = 0; i < *len; i++) {
		if ((*contents)[i] == '\n') {
			*contents += (num + 1);
			*len -= (num + 1);
			line[num] = '\0';
			ret = (char *)malloc (sizeof(line));
			strcpy (ret, line);
			return ret;
		} else {
			line[num] = (*contents)[i];
			num++;
		}
	}

	ret = (char *)malloc (sizeof(line));
	strcpy (ret, line);
	return ret;
}

void DoRequest (SERVERINFO *server)
{
	char *p, *rLine;
	char lasttoken[256];
	char recvBuff[4096];
	char buff[5000];
	fd_set stoc;
	int result;
	int fromlen;
	struct sockaddr dgFrom;
	SOCKET s;
	TIMEVAL delay;
	SOCKADDR_IN addr;
	char request[] = "status\n";
	char seps[]   = "\\";
	char *token;
	DWORD now;
	int msecs ,i;
	int players = 0;
	LVITEM lvI;

	memset(&addr, 0, sizeof(addr));
	memset(&recvBuff, 0, sizeof(recvBuff));
	addr.sin_family = AF_INET;
	addr.sin_port = 0;// htons(server->port);


	//memcpy (&addr.sin_addr, &server->ip, sizeof(addr.sin_addr));

	s = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);

	addr.sin_addr.S_un.S_addr = server->ip;
	addr.sin_port = htons(server->port);

	sprintf (buff, "Querying %s:%d...", inet_ntoa(addr.sin_addr), server->port);
	SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM)buff);

	timeBeginPeriod (1);
	server->startPing = timeGetTime ();
//	QueryPerformanceCounter (&server->startPing);
	for (i = 0; i < 3; i++) {
		result = sendto (s, request, sizeof(request), 0, (struct sockaddr *)&addr, sizeof(addr));
		if (result == SOCKET_ERROR) {
			sprintf (buff, "Can't send: error %d", WSAGetLastError());
			break;
		}
		memset (&stoc, 0, sizeof(stoc));
		FD_SET (s, &stoc);
		delay.tv_sec = 1;
		delay.tv_usec = 0;
		result = select (0, &stoc, NULL, NULL, &delay);
		if (result) {
			fromlen = sizeof(dgFrom);
			result = recvfrom (s, recvBuff, sizeof(recvBuff), 0, &dgFrom, &fromlen);
			if (result >= 0) {
				break;
			}
		} else {
			sprintf (buff, "Retrying %s:%d (attempt %d)", inet_ntoa (addr.sin_addr), server->port, i+1);
			result = -1;
		}
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM)buff);
	}
	now = timeGetTime();
	if (result >= 0) {
		p = recvBuff;

		//discard print
		rLine = GetLine (&p, &result);
		free (rLine);

		msecs = now - server->startPing;

		server->ping = msecs;

		//serverinfo
		rLine = GetLine (&p, &result);

		/* Establish string and get the first token: */
		token = strtok( rLine, seps );
		while( token != NULL ) {
			/* While there are tokens in "string" */
			if (!_stricmp (lasttoken, "mapname"))
				strcpy (server->szMapName, token);
			else if (!_stricmp (lasttoken, "maxclients"))
				server->maxClients = atoi(token);
			else if (!_stricmp (lasttoken, "hostname"))
				strcpy (server->szHostName, token);

			/* Get next token: */
			strcpy (lasttoken, token);
			token = strtok( NULL, seps );
		}

		free (rLine);

		//playerinfo
		strcpy (seps, " ");
		while (rLine = GetLine (&p, &result)) {
			/* Establish string and get the first token: */
			token = strtok( rLine, seps);
			server->players[players].score = atoi(token);

			token = strtok( NULL, seps);
			server->players[players].ping = atoi(token);

			token = strtok( NULL, "\"");
			//token++;

			if (token)
				strncpy (server->players[players].playername, token, sizeof(server->players[players].playername)-1);
			else
				server->players[players].playername[0] = '\0';

			players++;
			free (rLine);
		}

		server->curClients = players;

		memset (&lvI, 0, sizeof(lvI));

		lvI.mask = LVIF_TEXT | LVIF_PARAM;

   		lvI.iItem = globalServers++;
		lvI.iImage = 1;
		lvI.iSubItem = 0;
		lvI.lParam = (LPARAM)(server - servers);
		lvI.pszText = LPSTR_TEXTCALLBACK;

		globalPlayers += players;

		i = SendMessage (hWndList, LVM_INSERTITEM, 0, (LPARAM) (const LPLVITEM) &lvI);

		SendMessage (hWndList, LVM_SORTITEMS, 4, (LPARAM)CompareFunc);

		sprintf (buff, "%d Player%s", globalPlayers, globalPlayers != 1 ? "s" : "");
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 1, (LPARAM)buff);

		sprintf (buff, "%d Server%s", globalServers, globalServers != 1 ? "s" : "");
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 2, (LPARAM)buff);

		sprintf (buff, "Found %d player%s on '%s'", players, players != 1 ? "s" : "", server->szHostName, pending);
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM)buff);

	} else {
		sprintf (buff, "No response from %s:%d", inet_ntoa (addr.sin_addr), server->port);
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM)buff);
	}

	pending--;

	if (pending == 0) {
		sprintf (buff, "Completed. %d of %d server%s responded.", globalServers, numServers, numServers != 1 ? "s" : "");
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM)buff);
		EnableWindow (hWndRefresh, TRUE);
		lastSortOrder2 = 4;
	}

	timeEndPeriod (1);

	ExitThread (1);
}

void RequestHandler (void)
{
	int temp;

	pending = numServers;

	EnableWindow (hWndRefresh, FALSE);

	for (temp = 0; temp < numServers; temp++) {
		PingHandle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) DoRequest, &servers[temp], 0, &PingThreadID);
		if (PingHandle) {
			CloseHandle(PingHandle);
		}
		Sleep (50);
	}

	ExitThread (1);
}

/*void ParseServers (char *received, int len)
{
		unsigned long ip;
		int temp = 0;
		char *rLine;
		char *p;
		int remaining;
		char *q;
		int port, i;
		int llen;

		remaining = numServers;
		for (i = 0; i < numServers; i++) {
			if (servers[i].temporary) {
				memset (&servers[i], 0, sizeof(servers[i]));
				remaining--;
			}
		}
		numServers = remaining;

		llen = len;
		p = received;

		if (!isdigit (*p)) {
			SckError ("ERROR: Invalid response.");
			return;
		}

		SendDlgItemMessage (hDlgUpdate, IDC_PROGRESS1, PBM_DELTAPOS, (WPARAM)5, 0);

		while (rLine = GetLine (&p, &llen)) {
			q = rLine;
			while (*q && *q != ':') {
				q++;
				temp++;
			}
			rLine[temp] = '\0';
			q++;
			port = atoi(q);
			ip = inet_addr (rLine);
			servers[numServers].temporary = 1;
			servers[numServers].port = port;
			//memcpy (&servers[numServers].ip, &ip, sizeof (ip));
			strcpy (servers[numServers].host, rLine);

			if (++numServers == 64)
				break;

			temp = 0;
			free (rLine);
		}

		EndDialog (hDlgUpdate, 0);
		DoServerRefresh ();		
}*/

void GetServerList (void) {
	SOCKET master;
	HOSTENT *hp;
	int i, result;
	struct timeval delay;
	fd_set stoc;
	struct sockaddr_in dgFrom;
	char recvBuff[0xFFFF], *p;
	unsigned int addr;

	master = socket (AF_INET, SOCK_DGRAM, 0);

	SendDlgItemMessage (hDlgUpdate, IDC_PROGRESS1, PBM_DELTAPOS, (WPARAM)1, 0);

	SetDlgItemText (hDlgUpdate, IDC_STATUSMSG, "Resolving CodeRED Master Server...");
	//hp = gethostbyname ("http://68.170.64.159");

	addr = inet_addr("68.170.64.159");
	//addr = inet_addr("192.168.0.4"); //temporary for testing locally
    hp = gethostbyaddr((char *)&addr, 4, AF_INET);

	SendDlgItemMessage (hDlgUpdate, IDC_PROGRESS1, PBM_DELTAPOS, (WPARAM)2, 0);

	if (!hp) {
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "Error contacting master server.");
		SckError ("Couldn't resolve CodeRED Master Server!");
		ExitThread (1); 
	}

	memset (recvBuff, 0, sizeof(recvBuff));

	SetDlgItemText (hDlgUpdate, IDC_STATUSMSG, "Querying master server...");
	for (i = 0; i < 3; i++) {
		dgFrom.sin_family = AF_INET;
		dgFrom.sin_port = htons (27900);
		memset (&dgFrom.sin_zero, 0, sizeof(dgFrom.sin_zero));
		memcpy (&dgFrom.sin_addr, hp->h_addr_list[0], sizeof(dgFrom.sin_addr));
		result = sendto (master, "query", 5, 0, (const struct sockaddr *)&dgFrom, sizeof (dgFrom));
		if (result == SOCKET_ERROR) {
			SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "Error contacting master server.");
			SckError ("Couldn't contact master server.");
			ExitThread (1);
		}
		memset (&stoc, 0, sizeof(stoc));
		FD_SET (master, &stoc);
		delay.tv_sec = 2;
		delay.tv_usec = 0;
		result = select (0, &stoc, NULL, NULL, &delay);
		if (result) {
			int fromlen = sizeof(dgFrom);
			result = recvfrom (master, recvBuff, sizeof(recvBuff), 0, (struct sockaddr *)&dgFrom, &fromlen);
			if (result >= 0) {
				break;
			} else if (result == -1) {
				SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "Error contacting master server.");
				SckError ("Couldn't contact master server.");
				ExitThread (1);
			}
		} else {
			char buff[128];
			sprintf (buff, "Retrying query (attempt %d)...", i+1);
			SetDlgItemText (hDlgUpdate, IDC_STATUSMSG, buff);
		}
	}

	if (!result) {
		SendMessage (hWndStatus, SB_SETTEXT, (WPARAM) 0, (LPARAM) "Error contacting master server.");
		SckError ("Couldn't contact master server.");
		ExitThread (1);
	}
	SendDlgItemMessage (hDlgUpdate, IDC_PROGRESS1, PBM_DELTAPOS, (WPARAM)3, 0);

	p = recvBuff + 12;

	result -=12;

	numServers = 0;

	while (result) {
		servers[numServers].temporary = 1;
		memcpy (&servers[numServers].ip, p, sizeof (servers[numServers].ip));
		p += 4;
		memcpy (&servers[numServers].port, p, sizeof (servers[numServers].port));
		servers[numServers].port = ntohs(servers[numServers].port);
		p += 2;

		result -= 6;

		if (++numServers == 64)
			break;
	}

	DoServerRefresh ();
	EndDialog (hDlgUpdate, 0);
	ExitThread (0);
}

LRESULT CALLBACK DownloadProc(HWND hDlg, UINT message, UINT wParam, LONG lParam)
{
  switch (message) {
    case WM_INITDIALOG:
		hDlgUpdate = hDlg;
		SendDlgItemMessage (hDlg, IDC_PROGRESS1, PBM_SETRANGE, 0, MAKELPARAM(0, 5));
		ShowWindow(hDlg, 1);
		UpdateWindow(hDlg);
		PingHandle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)GetServerList, 0, 0, &PingThreadID);
		if (PingHandle) {
			CloseHandle(PingHandle);
		}
		return TRUE;
    case WM_COMMAND :
      switch (LOWORD(wParam)) {
        case IDC_CANCEL :
			EndDialog(hDlg, 0);
			return TRUE;
      }

	case WM_CLOSE:
		EndDialog(hDlg, 0);
		return TRUE;
                    
  }   
  return FALSE;
}

LRESULT WndProcMainInit2(HWND hwnd, UINT message, WPARAM wParam, LONG lParam)
{
	int i = 0;
//	FILE *in;
	char ININame[MAX_PATH];
	char *c;
	//LPSTR CmdLine = (LPSTR) lParam;
	HKEY hk;
	int size = sizeof(DWORD);
  //InitPart2();
	WSADATA ws;
	int error;

	ShowWindow(hwndMain, SW_SHOWNORMAL);
	UpdateWindow(hwndMain);

	
	error = WSAStartup ((WORD)MAKEWORD (1,1), &ws);

	if (error) {
		MessageBox (hwndMain, "Couldn't load Winsock!", "Error", MB_OK);
		PostQuitMessage (1);
		return FALSE;
	}

	GetModuleFileName(NULL, ININame, sizeof(ININame));
	c = strrchr(ININame, '.');
	if (c)
		*c = 0;

	strcat(ININame, ".ini");

	numServers = 0;

	i = -1;
	/*in = fopen("./server-1.0.9.cache", "rb");
	if (in) {
		while (!feof(in)) {
			if (fread (&servers[++i], sizeof(SERVERINFO), 1, in))
				numServers++;
		}
		fclose (in);
	}*/

	memset (q2Path, 0, sizeof(q2Path));
	memset (q2Exe, 0, sizeof(q2Exe));


	hWndList = LV_CreateListView (hwndMain, hThisInstance, 5, NULL);
	
	if (!(RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE\\COR\\CodeRED Server Browser", 0, KEY_READ, &hk))) {
		size = sizeof(DWORD);
		RegQueryValueEx(hk, "Alt. Startup Method", 0, NULL, (LPBYTE)&altmethod, (LPDWORD)&size);
		size = sizeof (q2Path);
		RegQueryValueEx(hk, "Q2Dir", 0, NULL, (LPBYTE)q2Path, (LPDWORD)&size);
		size = sizeof (q2Path);
		RegQueryValueEx(hk, "q2Exe", 0, NULL, (LPBYTE)q2Exe, (LPDWORD)&size);
		RegCloseKey(hk);
	}

	if (!q2Exe[0])
		strcpy (q2Exe, "xtremecr.exe");

	DialogBox(hThisInstance, MAKEINTRESOURCE(IDD_GSB_DIALOG), hwndMain, (DLGPROC)DownloadProc);
	//DoServerRefresh();
	//DialogBox(hThisInstance, MAKEINTRESOURCE(IDD_GSB_DIALOG), hwndMain, (DLGPROC)DownloadProc);

  return FALSE;
}

void UpdateServerInfo (NMITEMACTIVATE *info)
{
	LVITEM lvI;
	LVITEM pitem;
	int index;
	int i;

	SendMessage (hWndPlayerList, LVM_DELETEALLITEMS, 0, 0);

	if (info->iItem == -1)
		return;

	memset (&pitem, 0, sizeof(pitem));

	pitem.iItem = info->iItem;
	pitem.iSubItem = 0;
	pitem.mask = LVIF_PARAM;

	SendMessage (hWndList, LVM_GETITEM, 0, (LPARAM)(LPLVITEM)&pitem);
	
	index = pitem.lParam;

	memset (&lvI, 0, sizeof(lvI));

	lvI.mask = LVIF_TEXT | LVIF_PARAM | LVIF_STATE;

	lvI.state = 0; 
	lvI.stateMask = 0;

	// Initialize LVITEM members that are different for each item. 
	//for (index = 0; index < 3; index++)	{
	for (i = 0; i < servers[index].curClients; i++) {
   		lvI.iItem = i;
		lvI.iImage = 0;
		lvI.iSubItem = 0;
		lvI.lParam = (LPARAM)i;
		lvI.pszText = LPSTR_TEXTCALLBACK;

		SendMessage (hWndPlayerList, LVM_INSERTITEM, 0, (LPARAM) (const LPLVITEM) &lvI);
	}

	//SendMessage (hWndInfoList, LVM_INSERTITEM, 0, (LPARAM) (const LPLVITEM) &lvI);
}


//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProcMain(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	LVITEM pitem;
	int index;
	char buff[512];
	int wmId, wmEvent;

	switch (message) {
		case UM_INIT2 :
			return WndProcMainInit2(hWnd, message, wParam, (LONG)lParam);
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId) {
				case BUTTON_REFRESH:
					DoServerRefresh ();
					break;
				case BUTTON_ABOUT:
					//DialogBox(hThisInstance, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
					DialogBox(hThisInstance, MAKEINTRESOURCE(IDD_GSB_DIALOG), hwndMain, (DLGPROC)DownloadProc);
					break;
				case BUTTON_PROXY:
					DialogBox(hThisInstance, (LPCTSTR)IDD_GSB_PROXY, hWnd, (DLGPROC)Proxy);
					break;
				case BUTTON_EXIT:
					SaveStuff();
					PostQuitMessage (0);
					break;
				default:
					return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		/*case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
			// TODO: Add any drawing code here...
			EndPaint(hWnd, &ps);
			break;*/
		case WM_DESTROY:
			SaveStuff();
			PostQuitMessage(0);
			break;
		case WM_NOTIFY:
			// Parse the menu selections:
			switch (wParam) {
				case LIST_SERVERS:
					switch (((LPNMHDR) lParam)->code) {
						case NM_CLICK:
							UpdateServerInfo ((LPNMITEMACTIVATE)lParam);
							break;
						case NM_DBLCLK:
							RunQ2 ((LPNMITEMACTIVATE)lParam);
							break;
						case LVN_COLUMNCLICK:
							SendMessage (hWndList, LVM_SORTITEMS, ((LPNMLVDISPINFOW)lParam)->item.iItem, (LPARAM)CompareFunc);
							if (lastSortOrder2 == ((LPNMLVDISPINFOW)lParam)->item.iItem)
								lastSortOrder2 = -1;
							else
								lastSortOrder2 = ((LPNMLVDISPINFOW)lParam)->item.iItem;
							break;
						case LVN_GETDISPINFO:
							switch (((LPNMLVDISPINFOW)lParam)->item.iSubItem) {
								case 0:
									//index = ((LPNMLVDISPINFOW)lParam)->item.lParam;
									//((LPNMLVDISPINFOW)lParam)->item.pszText = (LPWSTR)servers[((LPNMLVDISPINFOW)lParam)->item.lParam].szHostName;
									lstrcpyn ((LPTSTR)((LPNMLVDISPINFOW)lParam)->item.pszText, servers[((LPNMLVDISPINFOW)lParam)->item.lParam].szHostName, lstrlen((LPCSTR)servers[((LPNMLVDISPINFOW)lParam)->item.lParam].szHostName)+1);
									break;
								case 1:
									{
										struct in_addr tmp;
										tmp.S_un.S_addr = servers[((LPNMLVDISPINFOW)lParam)->item.lParam].ip;
										sprintf (buff, "%s:%d", inet_ntoa (tmp), servers[((LPNMLVDISPINFOW)lParam)->item.lParam].port);
										//((LPNMLVDISPINFOW)lParam)->item.pszText = (LPWSTR)buff;
										lstrcpyn ((LPTSTR)((LPNMLVDISPINFOW)lParam)->item.pszText, buff, lstrlen((LPCSTR)buff)+1);
										break;
									}
								case 2:
									//((LPNMLVDISPINFOW)lParam)->item.pszText = (LPWSTR)servers[((LPNMLVDISPINFOW)lParam)->item.lParam].szMapName;
									lstrcpyn ((LPTSTR)((LPNMLVDISPINFOW)lParam)->item.pszText, servers[((LPNMLVDISPINFOW)lParam)->item.lParam].szMapName, lstrlen((LPCSTR)servers[((LPNMLVDISPINFOW)lParam)->item.lParam].szMapName)+1);
									break;
								case 3:
									sprintf (buff, "%d / %d", servers[((LPNMLVDISPINFOW)lParam)->item.lParam].curClients, servers[((LPNMLVDISPINFOW)lParam)->item.lParam].maxClients);
									//((LPNMLVDISPINFOW)lParam)->item.pszText = (LPWSTR)buff;
									lstrcpyn ((LPTSTR)((LPNMLVDISPINFOW)lParam)->item.pszText, buff, lstrlen((LPCSTR)buff)+1);
									break;
								case 4:
									((LPNMLVDISPINFOW)lParam)->item.mask |= LVIF_STATE;
									((LPNMLVDISPINFOW)lParam)->item.state = 0; 
									((LPNMLVDISPINFOW)lParam)->item.stateMask = 0;
									if (servers[((LPNMLVDISPINFOW)lParam)->item.lParam].ping <= 150) {
										((LPNMLVDISPINFOW)lParam)->item.iImage = 1;
									} else if (servers[((LPNMLVDISPINFOW)lParam)->item.lParam].ping <= 300) {
										((LPNMLVDISPINFOW)lParam)->item.iImage = 2;
									} else {
										((LPNMLVDISPINFOW)lParam)->item.iImage = 3;
									}

									sprintf (buff, "%d", servers[((LPNMLVDISPINFOW)lParam)->item.lParam].ping);
									//((LPNMLVDISPINFOW)lParam)->item.pszText = (LPWSTR)buff;
									lstrcpyn ((LPTSTR)((LPNMLVDISPINFOW)lParam)->item.pszText, buff, lstrlen((LPCSTR)buff)+1);
									break;
							}
						}
						break;
					case LIST_PLAYERS:
						switch (((LPNMHDR) lParam)->code) {
							case LVN_COLUMNCLICK:
								SendMessage (hWndPlayerList, LVM_SORTITEMS, ((LPNMLVDISPINFOW)lParam)->item.iItem, (LPARAM)CompareFunc2);
								if (lastSortOrder == ((LPNMLVDISPINFOW)lParam)->item.iItem)
									lastSortOrder = -1;
								else
									lastSortOrder = ((LPNMLVDISPINFOW)lParam)->item.iItem;
								break;
							case LVN_GETDISPINFO:
								index = SendMessage (hWndList, LVM_GETSELECTIONMARK, 0, 0);
								memset (&pitem, 0, sizeof(pitem));
								pitem.iItem = index;
								pitem.iSubItem = 0;
								pitem.mask = LVIF_PARAM;

								SendMessage (hWndList, LVM_GETITEM, 0, (LPARAM)(LPLVITEM)&pitem);
								index = pitem.lParam;
								switch (((LPNMLVDISPINFOW)lParam)->item.iSubItem) {
									case 0:
										//((LPNMLVDISPINFOW)lParam)->item.pszText = (LPWSTR)servers[index].players[((LPNMLVDISPINFOW)lParam)->item.lParam].playername;
										lstrcpyn ((LPTSTR)((LPNMLVDISPINFOW)lParam)->item.pszText, servers[index].players[((LPNMLVDISPINFOW)lParam)->item.lParam].playername, lstrlen((LPCSTR)servers[index].players[((LPNMLVDISPINFOW)lParam)->item.lParam].playername)+1);
										break;
									case 1:
										sprintf (buff, "%d", (LPWSTR)servers[index].players[((LPNMLVDISPINFOW)lParam)->item.lParam].score);
										//((LPNMLVDISPINFOW)lParam)->item.pszText = (LPWSTR)buff;
										lstrcpyn ((LPTSTR)((LPNMLVDISPINFOW)lParam)->item.pszText, buff, lstrlen((LPCSTR)buff)+1);
										break;
									case 2:
										sprintf (buff, "%d", (LPWSTR)servers[index].players[((LPNMLVDISPINFOW)lParam)->item.lParam].ping);
										//((LPNMLVDISPINFOW)lParam)->item.pszText = (LPWSTR)buff;
										lstrcpyn ((LPTSTR)((LPNMLVDISPINFOW)lParam)->item.pszText, buff, lstrlen((LPCSTR)buff)+1);
										break;
								}
						}
						break;
			}
			break;

		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

void GetResultsFromProxyDialog (HWND hDlg)
{
	memset (q2Path, 0, sizeof(q2Path));
	memset (q2Exe, 0, sizeof(q2Exe));

	SendDlgItemMessage (hDlg, IDC_Q2PATH, WM_GETTEXT, sizeof(q2Path), (LPARAM)q2Path);
	SendDlgItemMessage (hDlg, IDC_Q2EXE, WM_GETTEXT, sizeof(q2Exe), (LPARAM)q2Exe);
	altmethod = SendDlgItemMessage (hDlg, IDC_ALT, BM_GETCHECK, 0, 0);

	if (q2Path[0] && q2Path[strlen(q2Path)-1] != '\\')
		strcat (q2Path, "\\");
}

// Message handler for about box.
LRESULT CALLBACK Proxy(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		SetDlgItemText (hDlg, IDC_Q2PATH, q2Path);
		SetDlgItemText (hDlg, IDC_Q2EXE, q2Exe);

		SendDlgItemMessage (hDlg, IDC_ALT, BM_SETCHECK, altmethod, 0);
		return TRUE;

	case WM_CLOSE:
		GetResultsFromProxyDialog(hDlg);

		EndDialog(hDlg, 0);
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			GetResultsFromProxyDialog(hDlg);

			EndDialog(hDlg, 0);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

void RegisterClasses(void)
{
  WNDCLASSEX    wndclass;
  HICON hiSmall;
//  HICON hiLarge;

  hiSmall = LoadIcon(hThisInstance, MAKEINTRESOURCE(IDI_COMP));
  //hiLarge = LoadIcon(hThisInstance, MAKEINTRESOURCE(IDI_COMP));

  wndclass.cbSize = sizeof(wndclass);
  wndclass.style = CS_HREDRAW | CS_VREDRAW;
  wndclass.lpfnWndProc = WndProcMain;
  wndclass.cbClsExtra = 0;
  wndclass.cbWndExtra = 0;
  wndclass.hInstance = hThisInstance;
  wndclass.hIcon = hiSmall;
  wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
  wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW);
  wndclass.lpszMenuName = NULL;//MAKEINTRESOURCE(IDC_GSB);
  wndclass.lpszClassName = szAppName;
  wndclass.hIconSm = hiSmall;
  if (!RegisterClassEx(&wndclass))
    MessageBox(NULL, "Error registering class", szAppName, MB_OK);

}

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
  MSG	  msg;
	HICON hIcon;
	int test;

	hThisInstance = hInstance;
	

	if (hInstance)
		test = 1;

  RegisterClasses();

  InitCommonControls();
	

  hwndMain = CreateWindowEx(0, szAppName, szAppName, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX, 
                CW_USEDEFAULT, CW_USEDEFAULT, 560, 400, 
                NULL, (HMENU) NULL, hThisInstance, NULL);


      hIcon = (HICON)LoadImage(   hThisInstance,
                           MAKEINTRESOURCE(IDI_COMP),
                           IMAGE_ICON,
                           GetSystemMetrics(SM_CXSMICON),
                           GetSystemMetrics(SM_CYSMICON),
                           0);
      if(hIcon)
         {
         SendMessage(hwndMain, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
         }

  if (!hwndMain) {
    MessageBox(NULL, "Unable to create window", szAppName, MB_OK);
    return 1;
  }

	PostMessage(hwndMain, UM_INIT2, 0, (LPARAM) lpszCmdLine);


  while (GetMessage(&msg, NULL, 0, 0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return test;//(int)(msg.wParam);
}
