////////////////////////////////////////////////////////////////////////////
// TYPE DEFs
////////////////////////////////////////////////////////////////////////////

#ifndef _Q3PLUG_H_
#define _Q3PLUG_H_
#endif

#ifndef _NPAPI_H_
#include "npapi.h"
#endif


////////////////////////////////////////////////////////////////////////////
// CONSTANTS
////////////////////////////////////////////////////////////////////////////

#define GAME_Q3 1
#define GAME_Q2 2
#define GAME_HL 3
#define GAME_UT 4
#define GAME_TR 5
#define GAME_T2 6
#define GAME_QW 7
#define GAME_CW 8
#define GAME_MH 9
#define GAME_JK 10

#define INFO_ITEMS 4

// remove this if you have commctrl.h 1.2 or later
#define CDRF_NOTIFYSUBITEMDRAW 0x00000020
#define CDDS_SUBITEM 0x00020000


// size of receive buffer
#define BUFSIZE 1800

// custom window messages
#define WM_SERVER_RESPONSE    (WM_USER+0x300)

// button IDs
#define BUTTON1 150
#define BUTTON2 151
#define BUTTON3 152

// timer IDs
#define TIMER_TIMEOUT 170
#define TIMER_REFRESH 171

// list view IDs
#define LV1     160
#define LV2     161

////////////////////////////////////////////////////////////////////////////
// INTERFACE
////////////////////////////////////////////////////////////////////////////


// window procedures
LRESULT CALLBACK AboutDlgProc (HWND, UINT, WPARAM, LPARAM) ;
LRESULT CALLBACK PluginWindowProc (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK OptionsDlgProc (HWND, UINT, WPARAM, LPARAM);

// structs 
typedef struct _structPlayer {
  char* ping;
	char* frags;
	char *name;
} structPlayer;

typedef struct _structRule {
  char* name;
	char* value;
} structRule;

// plugin instance (one instance of this for each plugin window on a page)
// (todo: replace all this with a proper C++ class)
typedef struct _PluginInstance {
  NPWindow*		fWindow;
  uint16      fMode;
  HWND				fhWnd;
  WNDPROC			fDefaultWindowProc;
  
	HWND				listbox, listbox2;
  HWND				button1, button2, button3;

  HMENU       menu, subMenu;
  HGDIOBJ     bitmap;

  SOCKET			sock;
  LONGLONG		ticks;

  char        sortCol1, sortCol2;
  char        sortDir1, sortDir2;
  
  COLORREF    color, bgcolor,color2;

  char				server[128];
	char				text[128];
	char				ping[12];
	char				hostname[128];
  char        maxclients[16];
  char        numplayers[6];

 	char        *playerPos;
	char        *rulePos;
	char				*port;

  int         queryport;
	
  // malloc'ed each query
	char        *buffer;
  
  char        *columns[3];

  // function pointers (might become obsolete in a future C++ version)
  
  BOOL (* sendPacketProc) (_PluginInstance *This);
  BOOL (* receivePacketProc) (_PluginInstance *This);
  int  (* compareFunc) (char *val1, char *val2, int sortCol, int sortDir);
  void (* getColumns) (char *cols[]);
  void (* getInfo)(char *text[]);
  BOOL (* drawName) (_PluginInstance *This, HDC hdc, RECT win, char *name);
   
  // see window procedure for comments on this flag
  BOOL        initialized;
} PluginInstance;	

void UI_createLists(PluginInstance *This);
void UI_insertPlayer(PluginInstance *This, structPlayer p);
void UI_insertRule(PluginInstance *This, structRule r) ;
int CALLBACK ComparePlayerFrags(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
int CALLBACK CompareRuleName(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
void UI_invertSort(BOOL invertSort);
BOOL isOpen(SOCKET s);

void setGrayed(HMENU menu, int index, BOOL grayed);
BOOL isChecked(HMENU menu, int index);



