# Overwrite maps.lst with map names and titles
$mapsLines = @(
    'kpdm1 "Turf War"',
    'kpdm2 "Industrial Waste"',
    'kpdm3 "Mean Streets"',
    'kpdm4 "Urban Decay"',
    'kpdm5 "Central Towers"'
)
$mapsLines | Set-Content 'main\maps.lst'


# Overwrite autoexec.cfg with the intended content
$autoexecLines = @(
    'developer 1',
    'logfile 3',
    'alias   zoom "s1a;s1b"',
    'alias   unzoom "s2a;s2b"',
    '',
    'alias s1a fov "65"',
    'alias s2a fov "90"',
    '',
    'alias s1b bind mouse3 "unzoom"',
    'alias s2b bind mouse3 "zoom"',
	''
)

$autoexecLines | Set-Content 'main\autoexec.cfg'

# Overwrite default.cfg with the intended content
$defaultLines = @(
    '//',
    '// KEY BINDINGS',
    '//',
    '',
    'unbindall',
    '',
    'bind '' "inven_drop"',
    'bind 1 "use pipe"',
    'bind 2 "use pistol"',
    'bind 3 "use shotgun"',
    'bind 4 "use tommygun"',
    'bind 5 "use heavy machinegun"',
    'bind 6 "use grenade launcher"',
    'bind 7 "use bazooka"',
    'bind 8 "use flamethrower"',
    'bind 9 ""',
    'bind 0 ""',
    '',
    'bind g "holster"',
    'bind l "flashlight"',
    'bind t "messagemode"',
    'bind v "messagemode2"',
    'bind w "+forward"',
    'bind e ""',
    'bind r "reload"',
    '',
	'',
    '//',
    '// CHARACTER CONTROLS',
    '//',
    '',
    'bind    CTRL	  +movedown',
    'bind    ALT		  +strafe',
    '',
    'bind    ,           +moveleft',
    'bind    .           +moveright',
    'bind    DEL         +lookdown',
    'bind    PGDN        +lookup',
    'bind    END         centerview',
    'bind    a           +moveleft',
    'bind 	  s		  +back',
    'bind 	  f 		  +activate',
    'bind	  d		  +moveright',
    'bind	  c		  +movedown',
    '',
    'bind    TAB         inven',
    'bind    ENTER       invuse',
    'bind    [           invprev',
    'bind    ]           invnext',
    'bind    ''           invdrop',
    'bind	 B_SPACE	  invdrop',
    '',
    'bind	/		  weapnext',
    '',
    'bind    SHIFT 	  +speed',
    'bind    U_ARROW     +forward',
    'bind    D_ARROW     +back',
    'bind    L_ARROW     +left',
    'bind    R_ARROW     +right',
    'bind    SPACE       +moveup',
    '',
    '',
    '//',
    '// SPEECH',
    '//',
    '',
    'bind  x     key3',
    'bind	q	key2',
    'bind 	y 	key1',
    '',
    '//',
    '// MOUSE OPTIONS',
    '//',
    '',
    'bind  \           +mlook',
    '',
    '//',
    '// CLIENT ENVIRONMENT COMMANDS',
    '//',
    '',
    'bind    PAUSE       "pause"',
    'bind    ESC         "togglemenu"',
    'bind    ~           "toggleconsole"',
    'bind    `           "toggleconsole"',
    '',
    'bind  F1			"cmd help"',
    'bind	F2			"menu_savegame"',
    'bind	F3			"menu_loadgame"',
    'bind	F4			"menu_keys"',
    'bind	F5			"hud"',
    'bind	F6			"echo Quick Saving...; wait; save quick"',
    'bind  F7			""',
    'bind  F8			""',
    'bind	F9			"echo Quick Loading...; wait; load quick"',
    'bind	F10			"menu_quit"',
    'bind  F11			"screenshot"',
    'bind	F12			"quit"',
    '',
    'bind    +           "sizeup"',
    'bind    =           "sizeup"',
    'bind    -           "sizedown"',
    '',
    'bind    INS         +klook',
    '',
    '//',
    '// MOUSE BUTTONS',
    '//',
    '',
    'bind    MOUSE3      +activate',
    'bind    MOUSE1      +attack',
    'bind    MOUSE2      reload',
    '',
    '//',
    '// DEFAULT CVARS',
    '//',
    '',
    'set viewsize	  	    100',
    'set vid_fullscreen		1',
    'set win_noalttab	  	      0',
    'set sensitivity   	    5.5',
    'set crosshair			1',
    'set cl_run				1',
    'set cl_captions 			0',
    'set cl_allow_downloads	 	1',
    'set cl_fireworks			3',
    'set cl_bloodtime 		     10',
    'set hudguys				1',
    'set hudtalk 			1',
    'set hand				0',
    'set m_pitch  	  	  0.022',
    'set m_yaw        		  0.022',
    'set m_forward    		      1',
    'set m_side       	 	    0.8',
    'set s_khz			     11',
    'set s_loadas8bit 			0',
    'set s_mixahead 		    0.2',
    'set cd_nocd 			1',
    'set s_volume 			1',
    'set lookspring			0',
    'set lookstrafe			0',
    'set freelook			1',
    '',
    'set gl_shadows 			2',
    'set gl_specular 			0',
    'set r_lightflares			1',
    'set r_directional_lighting 	1',
    'set r_painskins 			2',
    '',
    '',
    '',
	'',
    '//---------------------------------------------',
    '// Kingpin stuff',
    'set gl_ext_palettedtexture "0"',
    'set vid_ref "gl"',
    'set gl_mode "0"',
    'set vid_gamma "1"',
    'set gl_driver "opengl32"',
    '',
    '//----------------------------------------------',
    '//',
    '// userinfo',
    '//',
    '',
    'set name thug',
    'set skin "male_thug/018 016 010"',
    '',
    '//----------------------------------------------',
    '',
    '//',
    '//	DEMO STUFF',
    '//',
    'alias   d1      "demomap logo.tga"',
    '//alias   d2      "demomap demo1.cin ; set nextserver d3"',
    '//alias   d3      "demomap idlog.cin ; set nextserver d4"',
    '//alias   d4      "demomap demo2.dm2 ; set nextserver d1"',
    '',
    '//',
    '// newgame command',
    '//',
    'alias   newgame " killserver ; maxclients 1 ; deathmatch 0 ; d1"',
    '',
    '//',
    '// kingpin +set dedicated 1',
    '// will run this command if no other +map is included',
    '//',
    'alias	dedicated_start	"map kpdm1"',
	'',
	''
)

$defaultLines | Set-Content 'main\default.cfg'

# Update server.cfg
(Get-Content 'main\server.cfg') `
 -replace 'set hostname "Gangbang Server"', 'set hostname "Gangbang Demo Server"' `
 -replace 'setmaster master.ogn.org', 'setmaster master.kingpin.info' `
 -replace '//map team_sr', '//map team_towers' |
 Set-Content 'main\server.cfg'